% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fv_S3.R
\name{op_fv}
\alias{op_fv}
\alias{key1.fv}
\alias{key1val.fv}
\alias{trapz.fv}
\alias{cumtrapz.fv}
\title{Operations on \link[spatstat.explore]{fv.object}}
\usage{
key1.fv(X, ...)

key1val.fv(X, ...)

trapz.fv(X, ...)

cumtrapz.fv(X, ...)
}
\arguments{
\item{X}{an \link[spatstat.explore]{fv.object}}

\item{...}{additional parameters, currently not in use}
}
\value{
Function \code{\link[=key1.fv]{key1.fv()}} returns a \link[base]{character} scalar.

Function \code{\link[=key1val.fv]{key1val.fv()}} returns a \link[base]{numeric} \link[base]{vector}.

Function \code{\link[=trapz.fv]{trapz.fv()}} returns a \link[base]{numeric} scalar.

Function \code{\link[=cumtrapz.fv]{cumtrapz.fv()}} returns a \link[base]{numeric} \link[base]{vector}.
}
\description{
Various operations on a function value \link[spatstat.explore]{fv.object}.
}
\details{
Function \code{\link[=key1.fv]{key1.fv()}} finds the name of primary outcome,
i.e., the \emph{black solid curve} as shown in \link[spatstat.explore]{plot.fv},
of an \link[spatstat.explore]{fv.object}.

Functions \code{\link[=trapz.fv]{trapz.fv()}} and \code{\link[=cumtrapz.fv]{cumtrapz.fv()}}
obtain the (cumulative)
\link[pracma]{trapz}oidal integration of
the area under the \emph{\strong{black solid curve}} (see function \code{\link[=key1.fv]{key1.fv()}})
of a function value \link[spatstat.explore]{fv.object}.
}
\examples{
library(spatstat.data)
library(spatstat.explore)
library(spatstat.geom) # ?spatstat.geom::subset.ppp

# numeric mark
plot(x <- Emark(spruces))
key1.fv(x)
trapz.fv(x)
x |> cumtrapz.fv() |> tail()

plot(x <- Vmark(spruces))
trapz.fv(x)
x |> cumtrapz.fv() |> tail()

plot(x <- markcorr(spruces))
trapz.fv(x)
x |> cumtrapz.fv() |> tail()

plot(x <- markvario(spruces))
trapz.fv(x)
x |> cumtrapz.fv() |> tail()

# multitype
(btc = subset.ppp(betacells, select = 'type'))
plot(x <- Gcross(btc, i = 'off', j = 'on'))
trapz.fv(x)
x |> cumtrapz.fv() |> tail()

plot(x <- Kcross(btc, i = 'off', j = 'on'))
trapz.fv(x)
x |> cumtrapz.fv() |> tail()

plot(x <- Lcross(btc, i = 'off', j = 'on'))
trapz.fv(x)
x |> cumtrapz.fv() |> tail()

plot(x <- Jcross(btc, i = 'off', j = 'on', r = 0:60))
trapz.fv(x)
x |> cumtrapz.fv() |> tail()

plot(x <- markconnect(btc, i = 'off', j = 'on'))
trapz.fv(x)
x |> cumtrapz.fv() |> tail()

plot(x <- roc.ppp(swedishpines, covariate = 'x'))
trapz.fv(x)
x |> cumtrapz.fv() |> tail()
}
\keyword{internal}
