% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weather.R
\name{WeatherData}
\alias{WeatherData}
\title{Weather Data Object}
\description{
Data structure containing weather data for a given site for several years.
}
\details{
All fields representing weather variables are vectors of length 365 times N,
where \emph{N} is the number of years for which weather data is stored. In
other words, every variable has one value for each of the 365 of each of
the \emph{N} years.
}
\section{Weather inputs}{
The weather input file should be organized as space separated columns
with a \code{year} column and at least the following parameters as headers
(further columns are ignored):
\itemize{
\item \code{DOY} day of year in given year
\item \code{Ta} average temperature of given day (Celsius).
\item \code{precip} precipitation in millimeter per day.
\item \code{PAR} photosynthetically active radiation in MJ/m^2^. Can be calculated
from average sunlight irradiance \code{SRad} in J/s/m^2^ as:
\code{PAR = SRad * 0.47 * 24 * 60 * 60 / 1e6}
\item \code{ET0} evapotranspiration in mm.
}

These parameters are stored in this object in the respective \code{PARAM_vec}
fields.
}

\section{Snow model}{
The precipitation and temperature inputs are used in order to estimate the
snow cover for each day by use of a snow model.
The employed model is as formulated by Kokkonen et al. 2006 and makes use
of parameters from Rango and Martinec, 1995.
}

\references{
\insertRef{rango1995RevisitingDegreeDayMethod}{growR}

\insertRef{kokkonen2006ConstructionDegreedaySnow}{growR}
}
\seealso{
\link{WeatherData}\verb{$read_weather()}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{weather_file}}{Name of provided weather data file.}

\item{\code{years}}{numeric Integer representation of the contained years.}

\item{\code{vec_size}}{Length of the PARAM_vec vectors, which is equal to \emph{number
of contained years} times 365.}

\item{\code{year_vec}}{Vector of length \emph{vec_size}, holding the year for the
respective index.}

\item{\code{W}}{A list generated by \code{get_weather_for_year()} which contains
weather data only for a given year. The keys in the list are:
\itemize{
\item aCO2 (atmospheric CO2 concentration in ppm)
\item year
\item DOY
\item Ta
\item Ta_sm (smoothed daily average temperature)
\item PAR
\item PP
\item PET
\item liquidP
\item melt
\item snow
\item ndays (number of days in this year)
}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-WeatherData-new}{\code{WeatherData$new()}}
\item \href{#method-WeatherData-read_weather}{\code{WeatherData$read_weather()}}
\item \href{#method-WeatherData-ensure_file_integrity}{\code{WeatherData$ensure_file_integrity()}}
\item \href{#method-WeatherData-calculate_day_length}{\code{WeatherData$calculate_day_length()}}
\item \href{#method-WeatherData-get_weather_for_year}{\code{WeatherData$get_weather_for_year()}}
\item \href{#method-WeatherData-clone}{\code{WeatherData$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WeatherData-new"></a>}}
\if{latex}{\out{\hypertarget{method-WeatherData-new}{}}}
\subsection{Method \code{new()}}{
Create a new WeatherData object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WeatherData$new(weather_file = NULL, years = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{weather_file}}{string Path to file containing the weather data to
be read.}

\item{\code{years}}{numeric Vector of years for which the weather is to be
extracted.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WeatherData-read_weather"></a>}}
\if{latex}{\out{\hypertarget{method-WeatherData-read_weather}{}}}
\subsection{Method \code{read_weather()}}{
Read weather data from supplied \emph{weather_file}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WeatherData$read_weather(weather_file, years = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{weather_file}}{Path to or name of file containing weather data.}

\item{\code{years}}{Years for which the weather is to be extracted.
Default (NULL) is to read in all found years.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WeatherData-ensure_file_integrity"></a>}}
\if{latex}{\out{\hypertarget{method-WeatherData-ensure_file_integrity}{}}}
\subsection{Method \code{ensure_file_integrity()}}{
Check if supplied input file is formatted correctly.

Check if required column names are present and fix NA entries.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WeatherData$ensure_file_integrity(weather)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{weather}}{data.table of the read input file with \code{header = TRUE}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WeatherData-calculate_day_length"></a>}}
\if{latex}{\out{\hypertarget{method-WeatherData-calculate_day_length}{}}}
\subsection{Method \code{calculate_day_length()}}{
Calculate the expected length of day based on a site's
geographical latitude.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WeatherData$calculate_day_length(latitude)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{latitude}}{numeric; geographical latitude in degrees.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WeatherData-get_weather_for_year"></a>}}
\if{latex}{\out{\hypertarget{method-WeatherData-get_weather_for_year}{}}}
\subsection{Method \code{get_weather_for_year()}}{
Extract state variables to the weather data for given
year and return them as a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WeatherData$get_weather_for_year(year)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{year}}{integer Year for which to extract weather data.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
W List containing the keys aCO2, year, DOY, Ta, Ta_sm, PAR,
PP, PET, liquidP, melt, snow, ndays.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WeatherData-clone"></a>}}
\if{latex}{\out{\hypertarget{method-WeatherData-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WeatherData$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
