% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cplxpair.R
\name{cplxpair}
\alias{cplxpair}
\title{Complex conjugate pairs}
\usage{
cplxpair(z, tol = 100 * .Machine$double.eps, MARGIN = 2)
}
\arguments{
\item{z}{Vector, matrix, or array of complex numbers.}

\item{tol}{Weighting factor \code{0 < tol < 1}, which determines the
tolerance of matching. Default: \code{100 * .Machine$double.eps}. (This
definition differs from the 'Octave' usage).}

\item{MARGIN}{Vector giving the subscripts which the function will be applied
over. E.g., for a matrix 1 indicates rows, 2 indicates columns, c(1, 2)
indicates rows and columns. Where X has named dimnames, it can be a
character vector selecting dimension names. Default: 2 (columns).}
}
\value{
Vector, matrix or array containing ordered complex conjugate pairs by
  increasing real parts.
}
\description{
Sort complex numbers into complex conjugate pairs ordered by increasing real
part.
}
\details{
The negative imaginary complex numbers are placed first within each pair. All
real numbers (those with \code{abs(Im (z) / z) < tol)} are placed after the
complex pairs.

An error is signaled if some complex numbers could not be paired and if all
complex numbers are not exact conjugates (to within \code{tol}).
}
\note{
There is no defined order for pairs with identical real parts but
  differing imaginary parts.
}
\examples{
r <- rbind(t(cplxpair(exp(2i * pi * 0:4 / 5))),
           t(exp(2i * pi *c(3, 2, 4, 1, 0) / 5)))

}
\seealso{
\code{\link{cplxreal}}
}
\author{
Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
