% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifft.R
\name{ifft}
\alias{ifft}
\alias{imvfft}
\title{Inverse Fast Fourier Transform}
\usage{
ifft(x)

imvfft(x)
}
\arguments{
\item{x}{Real or complex vector, array, or matrix.}
}
\value{
When \code{x} is a vector, the value computed and returned by
  \code{ifft} is the univariate inverse discrete Fourier transform of the
  sequence of values in \code{x}. Specifically, \code{y <- ifft(x)} is
  defined as \code{stats::fft(x, inverse = TRUE) / length(x)}. The
  \code{stats::fft} function called with \code{inverse = TRUE} replaces
  \code{exp(-2 * pi...)} with \code{exp(2 * pi)} in the definition of the
  discrete Fourier transform (see \code{\link[stats]{fft}}).

When \code{x} contains an array, \code{ifft} computes and returns the
normalized inverse multivariate (spatial) transform. By contrast,
\code{imvfft} takes a real or complex matrix as argument, and returns a
similar shaped matrix, but with each column replaced by its normalized
inverse discrete Fourier transform. This is useful for analyzing
vector-valued series.
}
\description{
Compute the inverse Fast Fourier Transform compatible with
'Matlab' and 'Octave'.
}
\details{
The \code{'fft'} function in the \code{'stats'} package can compute the
inverse FFT by specifying \code{inverse = TRUE}. However, that function does
\emph{not} divide the result by \code{length(x)}, nor does it return real
values when appropriate. The present function does both, and is this
compatible with 'Matlab' and 'Octave' (and differs from the \code{'ifft'}
function in the \code{'signal'} package, which does not return real values).
}
\examples{
res <- ifft(stats::fft(1:5))
res <- ifft(stats::fft(c(1+5i, 2+3i, 3+2i, 4+6i, 5+2i)))
res <- imvfft(stats::mvfft(matrix(1:20, 4, 5)))

}
\seealso{
\code{\link[stats]{fft}}
}
\author{
Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
