% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncauer.R
\name{ncauer}
\alias{ncauer}
\title{ncauer analog filter design}
\usage{
ncauer(Rp, Rs, n)
}
\arguments{
\item{Rp}{dB of passband ripple.}

\item{Rs}{dB of stopband ripple.}

\item{n}{filter order.}
}
\value{
A list of class Zpg with the following list elements:
\describe{
  \item{zero}{complex vector of the zeros of the model}
  \item{pole}{complex vector of the poles of the model}
  \item{gain}{gain of the model}
}
}
\description{
Compute the transfer function coefficients of a Cauer analog filter.
}
\details{
Cauer filters have equal maximum ripple in the passband and the stopband. The
Cauer filter has a faster transition from the passband to the stopband than
any other class of network synthesis filter. The term Cauer filter can be
used interchangeably with elliptical filter, but the general case of
elliptical filters can have unequal ripples in the passband and stopband. An
elliptical filter in the limit of zero ripple in the passband is identical to
a Chebyshev Type 2 filter. An elliptical filter in the limit of zero ripple
in the stopband is identical to a Chebyshev Type 1 filter. An elliptical
filter in the limit of zero ripple in both passbands is identical to a
Butterworth filter. The filter is named after Wilhelm Cauer and the transfer
function is based on elliptic rational functions.Cauer-type filters use
generalized continued fractions.[1]
}
\examples{
zpg <- ncauer(1, 40, 5)
freqz(zpg)
zplane(zpg)

}
\references{
[1]
 \url{https://en.wikipedia.org/wiki/Network_synthesis_filters#Cauer_filter}
}
\seealso{
\code{\link{Zpg}}, \code{\link{filter}}, \code{\link{ellip}}
}
\author{
Paulo Neis, \email{p_neis@yahoo.com.br}.\cr
Conversion to R Tom Short,\cr
 adapted by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
