% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schtrig.R
\name{schtrig}
\alias{schtrig}
\title{Schmitt Trigger}
\usage{
schtrig(x, lvl, st = NULL)
}
\arguments{
\item{x}{input data, specified as a numeric vector or matrix. In case of a
vector it represents a single signal; in case of a matrix each column is a
signal.}

\item{lvl}{threshold levels against which \code{x} is compared, specified as
a vector. If this is a scalar, the thresholds are symmetric around 0, i.e.
\code{c(-lvl, lvl)}.}

\item{st}{trigger state, specified as a vector of length \code{ncol(x}. The
trigger state is returned in the output list and may be passed again to a
subsequent call to \code{schtrig}. Default: NULL.}
}
\value{
a \code{\link{list}} containing the following variables:
\describe{
  \item{v}{vector or matrix of 0's and 1's, according to whether \code{x} is
  above or below \code{lvl}, or the value of \code{x} if indeterminate}
  \item{rng}{ranges in which the output is high, so the indexes
  \code{rng[1,i]:rng[2,i]} point to the i-th segment of 1s in \code{v}. See
  \code{\link{clustersegment}} for a detailed explanation.}
  \item{st}{trigger state, returned as a vector with a length of the number
  of columns in \code{x}.}
}
}
\description{
Multisignal Schmitt trigger with levels.
}
\details{
The trigger works compares each column in \code{x} to the levels in
\code{lvl}, when the value is higher than \code{max(lvl)}, the output
\code{v} is high (i.e. 1); when the value is below \code{min(lvl)} the output
is low (i.e. 0); and when the value is between the two levels the output
retains its value.
}
\examples{
t <- seq(0, 1, length.out = 100)
x <- sin(2 * pi * 2 * t) + sin(2 * pi * 5 * t) \%*\% matrix(c(0.8, 0.3), 1, 2)
lvl <- c(0.8, 0.25)
trig  <- schtrig (x, lvl)

op <- par(mfrow = c(2, 1))
plot(t, x[, 1], type = "l", xlab = "", ylab = "")
abline(h = lvl, col = "blue")
lines(t, trig$v[, 1], col = "red", lwd = 2)
plot(t, x[, 2], type = "l", xlab = "", ylab = "")
abline(h = lvl, col = "blue")
lines(t, trig$v[, 2], col = "red", lwd = 2)
par(op)

}
\seealso{
\code{\link{clustersegment}}
}
\author{
Juan Pablo Carbajal, \email{carbajal@ifi.uzh.ch}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
