% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zplane.R
\name{zplane}
\alias{zplane}
\alias{zplane.Arma}
\alias{zplane.Ma}
\alias{zplane.Sos}
\alias{zplane.Zpg}
\alias{zplane.default}
\title{Zero-pole plot}
\usage{
zplane(filt, ...)

\method{zplane}{Arma}(filt, ...)

\method{zplane}{Ma}(filt, ...)

\method{zplane}{Sos}(filt, ...)

\method{zplane}{Zpg}(filt, ...)

\method{zplane}{default}(filt, a, ...)
}
\arguments{
\item{filt}{for the default case, the moving-average coefficients of an ARMA
model or filter. Generically, \code{filt} specifies an arbitrary model or
filter operation.}

\item{...}{additional arguments are passed through to plot.}

\item{a}{the autoregressive (recursive) coefficients of an ARMA filter.}
}
\value{
No value is returned.
}
\description{
Plot the poles and zeros of a filter or model on the complex Z-plane
}
\details{
Poles are marked with an \code{x}, and zeros are marked with an \code{o}.
}
\note{
When results of \code{zplane} are printed, \code{plot} will be called.
  As with lattice plots, automatic printing does not work inside loops and
  function calls, so explicit calls to print or plot are needed there.
}
\examples{
## elliptic low-pass filter
elp <- ellip(4, 0.5, 20, 0.4)
zplane(elp)

}
\references{
\url{https://en.wikipedia.org/wiki/Pole-zero_plot}
}
\seealso{
\code{\link{freqz}}
}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net},\cr
 Stefan van der Walt \email{stefan@sun.ac.za},\cr
 Mike Miller.\cr
  Conversion to R by Tom Short,\cr
   adapted by Geert van Boxtel, \email{gjmvanboxtel@gmail.com}
}
