% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parzenwin.R
\name{parzenwin}
\alias{parzenwin}
\title{Parzen (de la Vallée Poussin) window}
\usage{
parzenwin(n)
}
\arguments{
\item{n}{Window length, specified as a positive integer.}
}
\value{
Parzen window, returned as a vector.
}
\description{
Return the filter coefficients of a Parzen window of length \code{n}.
}
\details{
Parzen windows are piecewise-cubic approximations of Gaussian windows.
}
\examples{

p <- parzenwin(64)
g <- gausswin(64)
plot (p, type = "l", xlab = "Samples", ylab =" Amplitude", ylim = c(0, 1))
lines(g, col = "red")

}
\author{
Sylvain Pelissier, \email{sylvain.pelissier@gmail.com}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
