% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ar_psd.R
\name{ar_psd}
\alias{ar_psd}
\alias{plot.ar_psd}
\alias{print.ar_psd}
\title{Power spectrum of AR model}
\usage{
ar_psd(
  a,
  v = 1,
  freq = 256,
  fs = 1,
  range = ifelse(is.numeric(a), "half", "whole"),
  method = ifelse(length(freq) == 1 && bitwAnd(freq, freq - 1) == 0, "fft", "poly")
)

\method{plot}{ar_psd}(
  x,
  yscale = c("linear", "log", "dB"),
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  ...
)

\method{print}{ar_psd}(
  x,
  yscale = c("linear", "log", "dB"),
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  ...
)
}
\arguments{
\item{a}{numeric vector of autoregressive model coefficients. The first
element is the zero-lag coefficient, which always has a value of 1.}

\item{v}{square of the moving average coefficient, specified as a positive
scalar Default: 1}

\item{freq}{vector of frequencies at which power spectral density is
calculated, or a scalar indicating the number of uniformly distributed
frequency values at which spectral density is calculated. Default: 256.}

\item{fs}{sampling frequency (Hz). Default: 1}

\item{range}{character string. one of:
\describe{
  \item{\code{"half"} or \code{"onesided"}}{frequency range of the spectrum
  is from zero up to but not including \code{fs / 2}. Power from negative
  frequencies is added to the positive side of the spectrum.}
  \item{\code{"whole"} or \code{"twosided"}}{frequency range of the spectrum
  is \code{-fs / 2} to \code{fs / 2}, with negative frequencies stored in
  "wrap around order" after the positive frequencies; e.g. frequencies for a
  10-point \code{"twosided"} spectrum are 0 0.1 0.2 0.3 0.4 0.5 -0.4 -0.3
  -0.2. -0.1.}
  \item{\code{"shift"} or \code{"centerdc"}}{same as \code{"whole"} but with
  the first half of the spectrum swapped with second half to put the
  zero-frequency value in the middle. If \code{freq} is a vector,
  \code{"shift"} is ignored.}
}
  Default: If model coefficients \code{a} are real, the default range is
  \code{"half"}, otherwise the default range is \code{"whole"}.}

\item{method}{method used to calculate the power spectral density, either
\code{"fft"} (use the Fast Fourier Transform) or \code{"poly"} (calculate
the power spectrum as a polynomial). This argument is ignored if the
\code{freq} argument is a vector. The default is \code{"poly"} unless the
\code{freq} argument is an integer power of 2.}

\item{x}{object to plot.}

\item{yscale}{character string specifying scaling of Y-axis; one of
\code{"linear"}, \code{"log"}, \code{"dB"}}

\item{xlab, ylab, main}{labels passed to plotting function. Default: NULL}

\item{...}{additional arguments passed to functions}
}
\value{
An object of class \code{"ar_psd"} , which is a list containing two
  elements, \code{freq} and \code{psd} containing the frequency values and
  the estimates of power-spectral density, respectively.
}
\description{
Compute the power spectral density of an autoregressive model.
}
\details{
This function calculates the power spectrum of the autoregressive model
\if{latex}{
  \deqn{x(n) = \sqrt{v} \cdot e(n) + \sum_{k=1}^{M} a(k) \cdot x(n-k)}
}
\if{html}{\preformatted{
                       M
x(n) = sqrt(v).e(n) + SUM a(k).x(n-k)
                      k=1
}}
where \code{x(n)} is the output of the model and \code{e(n)} is white noise.
}
\examples{
a <- c(1, -2.7607, 3.8106, -2.6535, 0.9238)
psd <- ar_psd(a)

}
\author{
Peter V. Lanspeary, \email{pvl@mecheng.adelaide.edu.au}.\cr
 Conversion to R by Geert van Boxtel, \email{gjmvanboxtel@gmail.com}
}
