% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residue.R
\name{residue}
\alias{residue}
\alias{rresidue}
\title{Partial fraction expansion}
\usage{
residue(b, a, tol = 0.001)

rresidue(r, p, k, tol = 0.001)
}
\arguments{
\item{b}{coefficients of numerator polynomial}

\item{a}{coefficients of denominator polynomial}

\item{tol}{tolerance. Default: 0.001}

\item{r}{residues of partial fraction expansion}

\item{p}{poles of partial fraction expansion}

\item{k}{direct term}
}
\value{
For \code{residue}, a list containing \code{r}, \code{p} and
  \code{k}. For \code{rresidue}, a list containing \code{b} and \code{a}.
}
\description{
Finds the residues, poles, and direct term of a Partial Fraction Expansion of
the ratio of two polynomials.
}
\details{
The call \code{res <- residue(b, a)} computes the partial fraction expansion
for the quotient of the polynomials, \code{b} and \code{a}.

The call \code{res <- rresidue(r, p, k)} performs the inverse operation and
computes the reconstituted quotient of polynomials, b(s) / a(s), from the
partial fraction expansion; represented by the residues, poles, and a direct
polynomial specified by \code{r}, \code{p} and \code{k}, and the pole
multiplicity \code{e}.
}
\examples{
b <- c(-4, 8)
a <- c(1, 6, 8)
rpk <- residue(b, a)
ba <- rresidue(rpk$r, rpk$p, rpk$k)

}
\author{
Tony Richardson, \email{arichard@stark.cc.oh.us},\cr
 Ben Abbott, \email{bpabbott@mac.com},\cr
 adapted by John W. Eaton.\cr
  Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}
}
