% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_sc.R
\name{compute_sc}
\alias{compute_sc}
\title{Compute the GLM systematic component.}
\usage{
compute_sc(mod, predictors)
}
\arguments{
\item{mod}{a fit object returned by one of \code{stats::lm}, \code{stats::glm}, \code{nnet::multinom}, or \code{MASS::polr}.}

\item{predictors}{matrix or data.frame of predictor values to compute the systematic component based on.}
}
\value{
a matrix of \eqn{n \times k}, where \eqn{k} is equal to 1 for all but multi-categorical models. This matrix contains the systematic component values for the provided predictors.
}
\description{
Compute the systematic component of a GLM of interest.
}
\details{
This function takes different model objects and knows how to treat the coefficient vector (or matrix) to obtain the systematic component.
}
\author{
Edoardo Costantini, 2023
}
