% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_pt_second_derivatives}
\alias{gsw_pt_second_derivatives}
\title{Second Derivatives of Potential Temperature}
\usage{
gsw_pt_second_derivatives(SA, CT)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}
}
\value{
A list containing \code{pt_SA_SA} [ K/(g/kg)^2 ], the second derivative of
potential temperature with respect to Absolute Salinity at constant
potential temperature, and \code{pt_SA_pt} [ 1/(g/kg) ], the derivative of
potential temperature with respect to Conservative Temperature and
Absolute Salinity, and \code{pt_pt_pt} [ 1/degC ], the second derivative of
potential temperature with respect to Conservative Temperature.
}
\description{
Second Derivatives of Potential Temperature
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05-4 dated 2017-08-07, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '5b4d959e54031f9e972f3e863f63e67fa4f5bfec'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
r <- gsw_pt_second_derivatives(SA, CT)
expect_equal(r$pt_SA_SA/1e-3, c(0.160307058371208, 0.160785497957769, 0.168647220588324,
                              0.198377949876584, 0.210181899321236, 0.220018966513329))
expect_equal(r$pt_SA_CT, c(0.001185581323691, 0.001187068518686, 0.001217629686266,
                         0.001333254154015, 0.001379674342678, 0.001418371539325))
expect_equal(r$pt_CT_CT/1e-3, c(-0.121979811279463, -0.123711264754503, -0.140136818504977,
                              -0.140645384127949, -0.113781055410824, -0.082417269009484))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_pt_second_derivatives.html}
}
