% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{as_raw_html}
\alias{as_raw_html}
\title{Get the HTML content of a \strong{gt} table}
\usage{
as_raw_html(data, inline_css = TRUE)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{inline_css}{An option to supply styles to table elements as inlined CSS
styles. This is useful when including the table HTML as part of an HTML
email message body, since inlined styles are largely supported in email
clients over using CSS in a \verb{<style>} block.}
}
\description{
Get the HTML content from a \code{gt_tbl} object as a single-element character
vector. By default, the generated HTML will have inlined styles, where CSS
styles (that were previously contained in CSS rule sets external to the
\verb{<table> element}) are included as \code{style} attributes in the HTML table's
tags. This option is preferable when using the output HTML table in an
emailing context.
}
\section{Examples}{


Use \code{\link{gtcars}} to create a \strong{gt} table. Add a header and then export as HTML
code with inlined CSS styles.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tab_html <-
  gtcars \%>\%
  dplyr::select(mfr, model, msrp) \%>\%
  dplyr::slice(1:5) \%>\%
  gt() \%>\%
  tab_header(
    title = md("Data listing from **gtcars**"),
    subtitle = md("`gtcars` is an R dataset")
  ) \%>\%
  as_raw_html()
}\if{html}{\out{</div>}}

What's returned is a single-element vector containing the HTML for the table.
It has only the \verb{<table>...</table>} part so it's not a complete HTML
document but rather an HTML fragment.
}

\section{Function ID}{

13-2
}

\seealso{
Other Export Functions: 
\code{\link{as_latex}()},
\code{\link{as_rtf}()},
\code{\link{extract_summary}()},
\code{\link{gtsave}()}
}
\concept{Export Functions}
