% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{opt_table_font}
\alias{opt_table_font}
\title{Option to define a custom font for the table}
\usage{
opt_table_font(data, font, weight = NULL, style = NULL, add = TRUE)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{font}{Either the name of a font available in the user system or a call
to \code{\link[=google_font]{google_font()}}, which has a large selection of typefaces.}

\item{weight}{The weight of the font. Can be a text-based keyword such as
\code{"normal"}, \code{"bold"}, \code{"lighter"}, \code{"bolder"}, or, a numeric value between
\code{1} and \code{1000}, inclusive. Note that only variable fonts may support the
numeric mapping of weight.}

\item{style}{The text style. Can be one of either \code{"normal"}, \code{"italic"}, or
\code{"oblique"}.}

\item{add}{Should this font be added to the front of the already-defined
fonts for the table? By default, this is \code{TRUE} and is recommended since
the list serves as fallbacks when certain fonts are not available.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{opt_table_font()} function makes it possible to define a custom font for
the entire \strong{gt} table. The standard fallback fonts are still set by default
but the font defined here will take precedence. You could still have
different fonts in select locations in the table, and for that you would need
to use \code{\link[=tab_style]{tab_style()}} in conjunction with the \code{\link[=cell_text]{cell_text()}} helper function.
}
\details{
We have the option to supply either a system font for the \code{font_name}, or, a
font available at the Google Fonts service by use of the \code{\link[=google_font]{google_font()}}
helper function.
}
\section{Examples}{


Use \code{\link{sp500}} to create a small \strong{gt} table, using \code{\link[=fmt_currency]{fmt_currency()}} to
provide a dollar sign for the first row of monetary values. Then, set a
larger font size for the table and use the \code{"Merriweather"} font (from
\emph{Google Fonts}, via \code{\link[=google_font]{google_font()}}) with two font fallbacks (\code{"Cochin"} and
the catchall \code{"Serif"} group).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{sp500 \%>\%
  dplyr::slice(1:10) \%>\%
  dplyr::select(-volume, -adj_close) \%>\%
  gt() \%>\%
  fmt_currency(
    columns = 2:5,
    rows = 1,
    currency = "USD",
    use_seps = FALSE
  ) \%>\%
  tab_options(table.font.size = px(18)) \%>\%
  opt_table_font(
    font = list(
      google_font(name = "Merriweather"),
      "Cochin", "Serif"
    )
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_opt_table_font_1.png" alt="This image of a table was generated from the first code example in the `opt_table_font()` help file." style="width:100\%;">
}}

Use \code{\link{sza}} to create an eleven-row table. Within \code{opt_table_font()}, set up
a preferred list of sans-serif fonts that are commonly available in macOS
(using part of the \code{\link[=default_fonts]{default_fonts()}} vector as a fallback).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{sza \%>\%
  dplyr::filter(
    latitude == 20 &
      month == "jan" &
      !is.na(sza)
  ) \%>\%
  dplyr::select(-latitude, -month) \%>\%
  gt() \%>\%
  opt_table_font(
    font = c(
      "Helvetica Neue", "Segoe UI",
      default_fonts()[-c(1:3)]
    )
  ) \%>\%
  opt_all_caps()
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_opt_table_font_2.png" alt="This image of a table was generated from the second code example in the `opt_table_font()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

9-9
}

\seealso{
Other table option functions: 
\code{\link{opt_align_table_header}()},
\code{\link{opt_all_caps}()},
\code{\link{opt_css}()},
\code{\link{opt_footnote_marks}()},
\code{\link{opt_horizontal_padding}()},
\code{\link{opt_row_striping}()},
\code{\link{opt_stylize}()},
\code{\link{opt_table_lines}()},
\code{\link{opt_table_outline}()},
\code{\link{opt_vertical_padding}()}
}
\concept{table option functions}
