% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_create_modify.R
\name{tab_header}
\alias{tab_header}
\title{Add a table header}
\usage{
tab_header(data, title, subtitle = NULL, preheader = NULL)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{title, subtitle}{Text to be used in the table title and, optionally, for
the table subtitle. We can elect to use the \code{\link[=md]{md()}} and \code{\link[=html]{html()}} helper
functions to style the text as Markdown or to retain HTML elements in the
text.}

\item{preheader}{Optional preheader content that is rendered above the table.
Can be supplied as a vector of text.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
We can add a table header to the \strong{gt} table with a title and even a
subtitle. A table header is an optional table part that is positioned above
the column labels. We have the flexibility to use Markdown formatting for the
header's title and subtitle. Furthermore, if the table is intended for HTML
output, we can use HTML in either of the title or subtitle.
}
\section{Examples}{


Use \code{\link{gtcars}} to create a \strong{gt} table. Add a header part with the
\code{tab_header()} function so that we get a title and a subtitle for the table.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gtcars \%>\%
  dplyr::select(mfr, model, msrp) \%>\%
  dplyr::slice(1:5) \%>\%
  gt() \%>\%
  tab_header(
    title = md("Data listing from **gtcars**"),
    subtitle = md("`gtcars` is an R dataset")
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_tab_header_1.png" alt="This image of a table was generated from the first code example in the `tab_header()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

2-1
}

\seealso{
Other part creation/modification functions: 
\code{\link{tab_caption}()},
\code{\link{tab_footnote}()},
\code{\link{tab_info}()},
\code{\link{tab_options}()},
\code{\link{tab_row_group}()},
\code{\link{tab_source_note}()},
\code{\link{tab_spanner_delim}()},
\code{\link{tab_spanner}()},
\code{\link{tab_stub_indent}()},
\code{\link{tab_stubhead}()},
\code{\link{tab_style_body}()},
\code{\link{tab_style}()}
}
\concept{part creation/modification functions}
