% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{loadResults}
\alias{loadResults}
\title{Load GWAS results into a single data.frame}
\usage{
loadResults(path, focus, ..., extraColumns = c(), .retainSE = FALSE)
}
\arguments{
\item{path}{vector of paths to result files created by \link{GWAS}}

\item{focus}{parameter name on which to calculate a Z score and p-value}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{extraColumns}{character vector of additional columns to load}

\item{.retainSE}{logical. Keep a column for the SE of the focus parameter}
}
\description{
A1 is the reference allele and A2 is the alternate allele.
}
\details{
Two columns are added, \code{Z} and \code{P}. \code{Z} is the
focal parameter divded by its standard error. \code{P} is the
unadjusted two-sided normal CDF corresponding to the absolute
\code{Z} score.
}
\examples{
tdir <- tempdir()
dir <- system.file("extdata", package = "gwsem")
pheno <- data.frame(anxiety=rnorm(500))
m1 <- buildItem(pheno, 'anxiety')
GWAS(m1, file.path(dir,"example.pgen"),
    file.path(tdir,"out.log"))
loadResults(file.path(tdir,"out.log"), "snp2anxiety")
}
