% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.kmeans}
\alias{h2o.kmeans}
\title{KMeans Model in H2O}
\usage{
h2o.kmeans(training_frame, x, k, estimate_k = FALSE, model_id,
  ignore_const_cols = TRUE, max_iterations = 10, standardize = TRUE,
  init = c("Furthest", "Random", "PlusPlus"), seed, nfolds = 0,
  fold_column = NULL, fold_assignment = c("AUTO", "Random", "Modulo",
  "Stratified"), keep_cross_validation_predictions = FALSE,
  keep_cross_validation_fold_assignment = FALSE,
  categorical_encoding = c("AUTO", "Enum", "OneHotInternal", "OneHotExplicit",
  "Binary", "Eigen"), max_runtime_secs = 0)
}
\arguments{
\item{training_frame}{An H2OFrame object containing the
variables in the model.}

\item{x}{(Optional) A vector containing the data columns on
which k-means operates.}

\item{k}{The max. number of clusters. If estimate_k is disabled, the model will find k centroids, otherwise it will find up to k centroids.}

\item{estimate_k}{Whether to estimate the number of clusters (<=k) iteratively and deterministically.}

\item{model_id}{(Optional) The unique id assigned to the resulting model. If
none is given, an id will automatically be generated.}

\item{ignore_const_cols}{A logical value indicating whether or not to ignore all the constant columns in the training frame.}

\item{max_iterations}{Maximum training iterations (if estimate_k is enabled, then this is for each inner Lloyds iteration).
Must be between 0 and 1e6 inclusive.}

\item{standardize}{Logical, indicates whether the data should be
standardized before running k-means.}

\item{init}{A character string that selects the initial set of k cluster
centers. Possible values are "Random": for random initialization,
"PlusPlus": for k-means plus initialization, or "Furthest": for
initialization at the furthest point from each successive center.
Additionally, the user may specify a the initial centers as a matrix,
data.frame, H2OFrame, or list of vectors. For matrices,
data.frames, and Frames, each row of the respective structure
is an initial center. For lists of vectors, each vector is an
initial center.}

\item{seed}{(Optional) Random seed used to initialize the cluster centroids.}

\item{nfolds}{(Optional) Number of folds for cross-validation.}

\item{fold_column}{(Optional) Column with cross-validation fold index assignment per observation}

\item{fold_assignment}{Cross-validation fold assignment scheme, if fold_column is not
specified, must be "AUTO", "Random",  "Modulo", or "Stratified".  The Stratified option will
stratify the folds based on the response variable, for classification problems.}

\item{keep_cross_validation_predictions}{Whether to keep the predictions of the cross-validation models}

\item{keep_cross_validation_fold_assignment}{Whether to keep the cross-validation fold assignment.}

\item{categorical_encoding}{Encoding scheme for categorical features
Can be one of "AUTO", "Enum", "OneHotInternal", "OneHotExplicit", "Binary", "Eigen". Default is "AUTO", which is "Enum".}

\item{max_runtime_secs}{Maximum allowed runtime in seconds for model training. Use 0 to disable.}
}
\value{
Returns an object of class \linkS4class{H2OClusteringModel}.
}
\description{
Performs k-means clustering on an H2O dataset.
}
\examples{
\donttest{
library(h2o)
h2o.init()
prosPath <- system.file("extdata", "prostate.csv", package="h2o")
prostate.hex <- h2o.uploadFile(path = prosPath)
h2o.kmeans(training_frame = prostate.hex, k = 10, x = c("AGE", "RACE", "VOL", "GLEASON"))
}
}
\seealso{
\code{\link{h2o.cluster_sizes}}, \code{\link{h2o.totss}}, \code{\link{h2o.num_iterations}},
         \code{\link{h2o.betweenss}}, \code{\link{h2o.tot_withinss}}, \code{\link{h2o.withinss}},
         \code{\link{h2o.centersSTD}}, \code{\link{h2o.centers}}
}

