% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.grep}
\alias{h2o.grep}
\title{Searches for matches to argument `pattern` within each element
 of a string column.}
\usage{
h2o.grep(pattern, x, ignore.case = FALSE, invert = FALSE,
  output.logical = FALSE)
}
\arguments{
\item{pattern}{A character string containing a regular expression.}

\item{x}{An H2O frame that wraps a single string column.}

\item{ignore.case}{If TRUE case is ignored during matching.}

\item{invert}{Identify elements that do not match the pattern.}

\item{output.logical}{If TRUE returns logical vector of indicators instead of list of matching positions}
}
\value{
H2OFrame holding the matching positions or a logical vector
if `output.logical` is enabled.
}
\description{
This function has similar semantics as R's native grep function
and it supports a subset of its parameters. Default behavior is
to return indices of the elements matching the pattern. Parameter
`output.logical` can be used to return a logical vector indicating
if the element matches the pattern (1) or not (0).
}
\examples{
\donttest{
library(h2o)
h2o.init()
addresses <- as.h2o(c("2307", "Leghorn St", "Mountain View", "CA", "94043"))
zip.codes <- addresses[h2o.grep("[0-9]{5}", addresses, output.logical = TRUE),]
}
}

