% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{as.numeric}
\alias{as.numeric}
\title{Convert H2O Data to Numeric}
\usage{
as.numeric(x)
}
\arguments{
\item{x}{a column from an H2OFrame data set.}

\item{...}{Further arguments to be passed from or to other methods.}
}
\description{
Converts an H2O column into a numeric value column.
}
\examples{
\donttest{
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(path = prostate_path)
prostate[, 2] <- as.factor (prostate[, 2])
prostate[, 2] <- as.numeric(prostate[, 2])
}
}
