% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.tabulate}
\alias{h2o.tabulate}
\title{Tabulation between Two Columns of an H2OFrame}
\usage{
h2o.tabulate(data, x, y, weights_column = NULL, nbins_x = 50,
  nbins_y = 50)
}
\arguments{
\item{data}{An H2OFrame object.}

\item{x}{predictor column}

\item{y}{response column}

\item{weights_column}{(optional) observation weights column}

\item{nbins_x}{number of bins for predictor column}

\item{nbins_y}{number of bins for response column}
}
\value{
Returns two TwoDimTables of 3 columns each
       count_table:    X     Y counts
       response_table: X meanY counts
}
\description{
Simple Co-Occurrence based tabulation of X vs Y, where X and Y are two Vecs in a given dataset.
Uses histogram of given resolution in X and Y.
Handles numerical/categorical data and missing values. Supports observation weights.
}
\examples{
\donttest{
library(h2o)
h2o.init()
df <- as.h2o(iris)
tab <- h2o.tabulate(data = df, x = "Sepal.Length", y = "Petal.Width",
             weights_column = NULL, nbins_x = 10, nbins_y = 10)
plot(tab)
}
}
