% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/communication.R
\name{h2o.show_progress}
\alias{h2o.show_progress}
\title{Enable Progress Bar}
\usage{
h2o.show_progress()
}
\description{
Enable Progress Bar
}
\examples{
\dontrun{
library(h2o)
h2o.init()
h2o.no_progress()

f <- "http://h2o-public-test-data.s3.amazonaws.com/smalldata/iris/iris_wheader.csv"
iris <- h2o.importFile(f)
iris["class"] <- as.factor(iris["class"])
predictors <- c("sepal_len","sepal_wid","petal_len","petal_wid")
splits <- h2o.splitFrame(iris, ratios = 0.8, seed = 1234)
train <- splits[[1]]
valid <- splits[[2]]
h2o.show_progress()

iris_km <- h2o.kmeans(x = predictors, 
                      training_frame = train, 
                      validation_frame = valid, 
                      k = 10, estimate_k = TRUE, 
                      standardize = FALSE, seed = 1234)
}
}
