% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.kurtosis}
\alias{h2o.kurtosis}
\alias{kurtosis.H2OFrame}
\title{Kurtosis of a column}
\usage{
h2o.kurtosis(x, ..., na.rm = TRUE)

kurtosis.H2OFrame(x, ..., na.rm = TRUE)
}
\arguments{
\item{x}{An H2OFrame object.}

\item{...}{Further arguments to be passed from or to other methods.}

\item{na.rm}{A logical value indicating whether \code{NA} or missing values should be stripped before the computation.}
}
\value{
Returns a list containing the kurtosis for each column (NaN for non-numeric columns).
}
\description{
Obtain the kurtosis of a column of a parsed H2O data object.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(path = prostate_path)
h2o.kurtosis(prostate$AGE)
}
}
