% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h3_algorithms.R
\name{grid_distance}
\alias{grid_distance}
\title{Grid distance between H3 cells}
\usage{
grid_distance(origin = NULL, destination = NULL, simple = TRUE)
}
\arguments{
\item{origin}{Character vector or list of 15-character indices generated by
H3.}

\item{destination}{Character vector or list of 15-character indices
generated by H3.}

\item{simple}{Logical; whether to return a vector of outputs or a list object
containing both inputs and outputs.}
}
\value{
The distance between two H3 cells, expressed as the minimum
  number of hexagon 'steps' required to get from the origin to the
  destination. Thus, a neighbour cell is one step away, and two cells
  with one hexagon between them are two steps apart.
}
\description{
This function gets the grid distance between two H3 cell indices.
}
\note{
Input H3 indices must be of the same resolution or results cannot be
  computed. This function may fail to find the distance between two indices
  if they are very far apart or on opposite sides of a pentagon.
}
\examples{
\dontrun{
nc <- sf::st_read(system.file("shape/nc.shp", package="sf"), quiet = TRUE)
nc_pts <- sf::st_centroid(nc[c(1, 2), ])
nc_6 <- point_to_h3(nc_pts, res = 6)
# how far apart are these two addresses?
grid_distance(nc_6[1], nc_6[2])
}
}
