% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_to_2d.R
\name{mesh_to_2d}
\alias{mesh_to_2d}
\title{Transform 3D mesh into 2D outline}
\usage{
mesh_to_2d(mesh, L0 = NULL, plot = FALSE, silent = TRUE)
}
\arguments{
\item{mesh}{A mesh3d object.}

\item{L0}{(Optional) The desired DEM resolution in same units at the 3D mesh.}

\item{plot}{logical. Plot the output?}

\item{silent}{logical. Defaults to not showing warnings.}
}
\value{
A data frame.
}
\description{
Turns a 3D Mesh file into an xy data frame.
}
\details{
The function uses the vertices of the mesh object and projects them on the XY plane.
Then, only points that define the perimeter of the shape are maintained.
}
\examples{
mcap_2d <- mesh_to_2d(mcap, plot = TRUE)

geometry::polyarea(mcap_2d$x, mcap_2d$y) # area
planar(mcap)

perimeter(mcap_2d) # perimeter
circularity(mcap_2d) # circularity
fd_boxes(mcap_2d) # fractal dimension

}
