% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/looptools.R
\name{loop_2pt}
\alias{loop_2pt}
\title{compute two-point correlation function between quark loops}
\usage{
loop_2pt(loop_snk, loop_src, random_vectors_outer_product = FALSE,
  nstoch_to_avg = "all")
}
\arguments{
\item{loop_snk}{'raw_cf' container with spin-projected quark loop
at sink (see \link{loop_spin_project})}

\item{loop_src}{'raw_cf' container with spin-projected quark loop
at source (see \link{loop_spin_project})}

\item{random_vectors_outer_product}{Boolean.
For testing purposes, the average over all
random sample combinations can be carried out explicitly
as \eqn{ \sum_{i \neq j} Tr[ \Gamma_snk M_i ] Tr[ \Gamma_src M_j ] }
instead of the (much faster) equivalent
\eqn{ (\sum_i Tr[ \Gamma_snk M_i ])*(\sum_j Tr[ \Gamma_src M_j ]) -
                    \sum_i ( Tr[ \Gamma_snk M_i ] Tr[ \Gamma_src M_i ] ) }.}

\item{nstoch_to_avg}{String or integer, how many of the available stochastic
samples should be averaged over. See \link{loop_stochav} for
details.}
}
\value{
'raw_cf' container with two-point function of these two quark loops.
In the calculation, both averaging over all source locations and
the average over all stochastic sample combinations are performed.
}
\description{
compute two-point correlation function between quark loops
}
