% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_cf.R
\name{block.raw_cf}
\alias{block.raw_cf}
\title{Block average correlation function data}
\usage{
block.raw_cf(cf, block_length)
}
\arguments{
\item{cf}{\code{raw_cf} object}

\item{block_length}{Integer, number of successive measurements to average over.}
}
\value{
cf \code{raw_cf} object with the data member reduced in its first dimension
by a factor of \code{block_length} and restricted (at the end) to the number
of measurements divisible by \code{block_length}.
}
\description{
Block \code{block_length} sequential measurements of the correlation
function together. This occurs, for example, when multiple
stochastic noise vectors are used per measurement or multiple
source locations. Alternatively, it can also be used to
account for auto-correlations in the data. If the total number
of measurements is not divisible by \code{block_length}, the last
measurements are discarded.
}
