% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_lasso.R
\name{cv_lasso}
\alias{cv_lasso}
\title{Cross-validated Lasso on Indicator Bases}
\usage{
cv_lasso(x_basis, y, n_lambda = 100, n_folds = 10, center = FALSE)
}
\arguments{
\item{x_basis}{A \code{dgCMatrix} object corresponding to a sparse matrix of
the basis functions generated for the HAL algorithm.}

\item{y}{A \code{numeric} vector of the observed outcome variable values.}

\item{n_lambda}{A \code{numeric} scalar indicating the number of values of
the L1 regularization parameter (lambda) to be obtained from fitting the
Lasso to the full data. Cross-validation is used to select an optimal
lambda (that minimizes the risk) from among these.}

\item{n_folds}{A \code{numeric} scalar for the number of folds to be used in
the cross-validation procedure to select an optimal value of lambda.}

\item{center}{binary. If \code{TRUE}, covariates are centered. This is much
slower, but matches the \code{glmnet} implementation. Default \code{FALSE}.}
}
\description{
Fits Lasso regression using a customized procedure, with cross-validation
based on \pkg{origami}
}
