% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_basis.R
\name{enumerate_basis}
\alias{enumerate_basis}
\title{Enumerate Basis Functions}
\usage{
enumerate_basis(
  x,
  max_degree = NULL,
  smoothness_orders = rep(0, ncol(x)),
  include_zero_order = FALSE,
  include_lower_order = FALSE,
  num_knots = NULL
)
}
\arguments{
\item{x}{An input \code{matrix} containing observations and covariates
following standard conventions in problems of statistical learning.}

\item{max_degree}{The highest order of interaction terms for which the basis
functions ought to be generated. The default (\code{NULL}) corresponds to
generating basis functions for the full dimensionality of the input matrix.}

\item{smoothness_orders}{An integer vector of length \code{ncol(x)}
specifying the desired smoothness of the function in each covariate. k = 0
is no smoothness (indicator basis), k = 1 is first order smoothness, and so
on. For an additive model, the component function for each covariate will
have the degree of smoothness as specified by smoothness_orders. For
non-additive components (tensor products of univariate basis functions),
the univariate basis functions in each tensor product have smoothness
degree as specified by smoothness_orders.}

\item{include_zero_order}{A \code{logical}, indicating whether the zeroth
order basis functions are included for each covariate (if \code{TRUE}), in
addition to the smooth basis functions given by \code{smoothness_orders}.
This allows the algorithm to data-adaptively choose the appropriate degree
of smoothness.}

\item{include_lower_order}{A \code{logical}, like \code{include_zero_order},
except including all basis functions of lower smoothness degrees than
specified via \code{smoothness_orders}.}

\item{num_knots}{A vector of length \code{max_degree}, which determines how
granular the knot points to generate basis functions should be for each
degree of basis function. The first entry of \code{num_knots} determines
the number of knot points to be used for each univariate basis function.
More generally, The kth entry of \code{num_knots} determines the number of
knot points to be used for the kth degree basis functions. Specifically,
for a kth degree basis function, which is the tensor product of k
univariate basis functions, this determines the number of knot points to be
used for each univariate basis function in the tensor product.}
}
\value{
A \code{list} of basis functions generated for all covariates and
interaction thereof up to a pre-specified degree.
}
\description{
Generate basis functions for all covariates and interaction terms thereof up
to a specified order/degree.
}
\examples{
\donttest{
gendata <- function(n) {
  W1 <- runif(n, -3, 3)
  W2 <- rnorm(n)
  W3 <- runif(n)
  W4 <- rnorm(n)
  g0 <- plogis(0.5 * (-0.8 * W1 + 0.39 * W2 + 0.08 * W3 - 0.12 * W4))
  A <- rbinom(n, 1, g0)
  Q0 <- plogis(0.15 * (2 * A + 2 * A * W1 + 6 * A * W3 * W4 - 3))
  Y <- rbinom(n, 1, Q0)
  data.frame(A, W1, W2, W3, W4, Y)
}
set.seed(1234)
data <- gendata(100)
covars <- setdiff(names(data), "Y")
X <- as.matrix(data[, covars, drop = FALSE])
basis_list <- enumerate_basis(X)
}

}
