% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{min_samples}
\alias{min_samples}
\alias{min_count_laa_data}
\alias{min_age_groups}
\title{Count number of length-at-age samples or age groups at each level and return
those with greater than equal to the minimum desired number}
\usage{
min_count_laa_data(
  data,
  sub_levels = NULL,
  min_age_sample_size = NULL,
  min_total_sample_size = NULL,
  min_age_groups = NULL
)

min_age_groups(data, sub_levels = NULL, min_age_grps)
}
\arguments{
\item{data}{Data.frame with length-at-age data}

\item{sub_levels}{The levels at which to check}

\item{min_age_sample_size}{Only applicable to alk models. The minimum
number of samples that must be in each age group in order to create an alk}

\item{min_total_sample_size}{Only applicable to alk models. The minimum
number of samples that must be in data (within level) in order to create an
alk}

\item{min_age_groups}{Only applicable to alk models. The minimum number of
age groups that must be in data (within level) in order to create an alk}

\item{min_age_grps}{The minimum number of age groups that must be present
in data to create an ALK}
}
\value{
A data.frame just like \code{data}, but with samples excluded that
don't meet the required number of samples in \code{min_sample_size}
}
\description{
These are helper shortcut functions to determine if data meet the minimum
desired number of age groups and/or sample sizes.
}
