% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanr_fbiad.R
\name{hanr_fbiad}
\alias{hanr_fbiad}
\title{Anomaly detector using FBIAD}
\usage{
hanr_fbiad(sw_size = 30)
}
\arguments{
\item{sw_size}{Window size for FBIAD}
}
\value{
hanr_fbiad object
Forward and Backward Inertial Anomaly Detector (FBIAD) detects anomalies in time series. Anomalies are observations that differ from both forward and backward time series inertia \url{doi:10.1109/IJCNN55064.2022.9892088}.
}
\description{
Anomaly detector using FBIAD
}
\examples{
library(daltoolbox)

# Load anomaly example data
data(examples_anomalies)

# Use a simple example
dataset <- examples_anomalies$simple
head(dataset)

# Configure FBIAD detector
model <- hanr_fbiad()

# Fit the model
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected anomalies
print(detection[(detection$event),])

}
\references{
\itemize{
\item Lima, J., Salles, R., Porto, F., Coutinho, R., Alpis, P., Escobar, L., Pacitti, E.,
Ogasawara, E. Forward and Backward Inertial Anomaly Detector: A Novel Time Series
Event Detection Method. Proceedings of the International Joint Conference on Neural
Networks, 2022. doi:10.1109/IJCNN55064.2022.9892088
}
}
