% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_metadata.R
\name{join_metadata}
\alias{join_metadata}
\title{Add metadata to long distance matrix}
\usage{
join_metadata(dist, meta, isolate = "ISOLATES", group = "CLUSTER",
  remove_ind = TRUE)
}
\arguments{
\item{dist}{A data.frame produced by dist_long function}

\item{meta}{A data.frame with one column of IDs that match the IDs in \code{dist_long}}

\item{isolate}{A character string with the name of the column in the meta data.frame with the ID data}

\item{group}{A character string with the name of column containing the grouping variable}

\item{remove_ind}{A boolean whether to remove intermediary columns}
}
\description{
This functions takes the output from \code{dist_long}, plus a
data.frame with metadata, and attaches it to the data.frame output from
\code{dist_long}. It uses a column in the metadata data.frame as a key to
join the two data.frames. So, it requires a column of data in the metadata
data.frame to have same ID labels as those in the pairwise comparison table.
}
\details{
The output from \code{dist_long} with an additional column containing
a factor, with levels composed of joining the categories in the \code{group}
colum of the metadata data.frame for each pairwise comparison. For example,
if one row has distance between samples id1 and id2, and in the grouping column
of the metadata id1 is identified as part of group 'A', and id2 is identified
as part of group 'B', then the output from that row will 'AB'. If they were
from the same group, say 'A', the output would be just 'A'. In this way
it is easy to identify pairs of isolates that are from the same group, and
pairs of isolates that are from different groups.
}
\examples{
\dontrun{
data(woodmouse)
data(woodmouse_meta)
dist_df <- dist_long(woodmouse)
join_metadata(dist_df, woodmouse_meta, isolate = 'SAMPLE_ID', group = 'CLUSTER', remove_ind = TRUE)
}
}

