% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_over_self.R
\name{plot_over_self}
\alias{plot_over_self}
\title{Plot individual parameter estimates over self-placements}
\usage{
plot_over_self(
  object,
  par = "chi",
  estimate = "median",
  names = NULL,
  parlabel = NULL,
  fill = "#2166AC",
  color = "#053061",
  width = 0.7,
  alpha = 0.5,
  outlier.size = 0.3,
  median_color = "black",
  median_lwd = 0.7
)
}
\arguments{
\item{object}{An object of class \code{stanfit} produced by \code{hbam()}, a list produced by \code{fbam()}, or a \code{list} of such objects, which will produce a faceted plot.}

\item{par}{Character: Name of the parameter to be plotted. One of the following: \code{"alpha"}, \code{"beta"}, \code{"abs_beta"}, \code{"lambda"}, or \code{"chi"}. Defaults to \code{"chi"}. Further individual-level parameters like \code{"eta"} can be specified if these have been passed to \code{hbam()} via the argument \code{extra_pars} when fitting the model. (Note that homoskedastic models have no \code{"eta"} parameters and "NF"-type models have no \code{"lambda"} or \code{"kappa"} parameters.)}

\item{estimate}{Character: Specifying which type of posterior point estimate to use. One of \code{"median"} and \code{"mean"}. Defaults to \code{"median"}. This only applies for \code{stanfit} objects.}

\item{names}{An optional character vector of model names of same length as the supplied list of models.}

\item{parlabel}{An optional character containing an alternative label for the parameter (will be parsed if passed as an expression).}

\item{fill}{Fill color of boxes. Passed on to \code{ggplot2::geom_boxplot()}.}

\item{color}{Color of outer lines. Passed on to \code{ggplot2::geom_boxplot()}.}

\item{width}{Width of boxes. Passed on to \code{ggplot2::geom_boxplot()}.}

\item{alpha}{Number in [0,1]: Inverse level of transparency for fill color.}

\item{outlier.size}{Size of dots representing outliers. Passed on to \code{ggplot2::geom_boxplot()}.}

\item{median_color}{Color of solid line representing the median.}

\item{median_lwd}{Thickness of solid line representing the median.}
}
\value{
A \code{ggplot} object.
}
\description{
Create a boxplot of individual parameter point estimates from an HBAM model over self-placements
}
