% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hce.R
\name{plot.hce}
\alias{plot.hce}
\title{A plot method for \code{hce} objects}
\usage{
\method{plot}{hce}(x, ...)
}
\arguments{
\item{x}{an object of class \code{hce} created by \code{as_hce()}.}

\item{...}{additional arguments to be passed to \code{\link[base:plot]{base::plot()}} function.}
}
\value{
no return value, called for plotting.
}
\description{
A plot method for \code{hce} objects
}
\examples{
d <- as_hce(KHCE)
res <- calcWO(AVAL ~ TRTP, data = d)
plot(d, col = 2, type = 'l', ylab = "Active", xlab = "Control", lwd = 2)
polygon(c(0, 1, 1, 0), c(1, 1, 1, 0), col = 2)
legend("bottomright", legend = paste0("WP = ", round(res$WP, 5)))
}
\references{
Bamber D. "The area above the ordinal dominance graph and the area below the receiver operating characteristic graph." Journal of Mathematical Psychology 12.4 (1975): 387-415. \url{doi:10.1016/0022-2496(75)90001-2}
}
