% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdMTD.R
\name{hdMTD}
\alias{hdMTD}
\title{Inference in MTD models}
\usage{
hdMTD(X, d, method = "FS", ...)
}
\arguments{
\item{X}{A vector or single-column data frame containing a chain sample.}

\item{d}{A positive integer representing an upper bound for the chain order.}

\item{method}{A character string indicating the method for estimating the relevant lag set.
The available methods are: "FS" (default), "FSC", "CUT", and "BIC". See the \emph{Details} section
and the documentation of the corresponding method functions for more information.}

\item{...}{Additional arguments for the selected method. If not specified, default values
will be used (see \emph{Details} ).}
}
\value{
A vector containing the estimated relevant lag set.
}
\description{
This function estimates the relevant lag set in a Mixture Transition Distribution (MTD) model
using one of the available methods. By default, it applies the Forward Stepwise ("FS") method,
which is particularly useful in high-dimensional settings.
The available methods are:
\itemize{
\item "FS" (Forward Stepwise): selects the lags by a criteria that depends on their oscillations.
\item "CUT": a method that selects the relevant lag set based on a predefined threshold.
\item "FSC" (Forward Stepwise and Cut): applies the "FS" method followed by the "CUT" method.
\item "BIC": selects the lag set using the Bayesian Information Criterion.
}
}
\details{
The function dynamically calls the corresponding method function (e.g., \code{\link[=hdMTD_FSC]{hdMTD_FSC()}} for
\code{method = "FSC"}). Additional parameters specific to each method can be provided via \code{...},
and default values are used for unspecified parameters.

#' This function serves as a wrapper for the method-specific functions:
\itemize{
\item \code{\link[=hdMTD_FS]{hdMTD_FS()}}, for \code{method = "FS"}
\item \code{\link[=hdMTD_FSC]{hdMTD_FSC()}}, for \code{method = "FSC"}
\item \code{\link[=hdMTD_CUT]{hdMTD_CUT()}}, for \code{method = "CUT"}
\item \code{\link[=hdMTD_BIC]{hdMTD_BIC()}}, for \code{method = "BIC"}
}

Any additional parameters (\code{...}) must match those accepted by the corresponding method function.
If a parameter value is not explicitly provided, a default value is used.
The main default parameters are:
\itemize{
\item \code{S = seq_len(d)}: Used in "BIC" or "CUT" methods.
\item \code{l = d}. Required in "FS" or "FSC" methods.
\item \code{alpha = 0.05}, \code{mu = 1}. Used in "CUT" or "FSC" methods.
\item \code{xi = 0.5}.  Used in "CUT", "FSC" or "BIC" methods.
\item \code{minl = 1}, \code{maxl = length(S)}, \code{byl = FALSE}. Used in "BIC" method.
All default values are specified in the documentation of the method-specific functions.
}
}
\examples{
X <- testChains[,1]
hdMTD(X = X, d = 5, method = "FS", l = 2)
hdMTD(X = X, d = 5, method = "BIC", xi = 1, minl = 3, maxl = 3)

}
