// (c) The HDF Group
#ifndef H5Spublic_H
#define H5Spublic_H
#include "H5public.h"
#include "H5Ipublic.h"
#define H5S_ALL 0
#define H5S_BLOCK 1
#define H5S_PLIST 2
#define H5S_UNLIMITED HSIZE_UNDEF
#define H5S_MAX_RANK 32
#define H5S_SEL_ITER_GET_SEQ_LIST_SORTED                                                                     \
    0x0001
#define H5S_SEL_ITER_SHARE_WITH_DATASPACE                                                                    \
    0x0002
typedef enum H5S_class_t {
    H5S_NO_CLASS = -1,
    H5S_SCALAR   = 0,
    H5S_SIMPLE   = 1,
    H5S_NULL     = 2
} H5S_class_t;
typedef enum H5S_seloper_t {
    H5S_SELECT_NOOP = -1,
    H5S_SELECT_SET  = 0,
    H5S_SELECT_OR,
    H5S_SELECT_AND,
    H5S_SELECT_XOR,
    H5S_SELECT_NOTB,
    H5S_SELECT_NOTA,
    H5S_SELECT_APPEND,
    H5S_SELECT_PREPEND,
    H5S_SELECT_INVALID
} H5S_seloper_t;
typedef enum {
    H5S_SEL_ERROR      = -1,
    H5S_SEL_NONE       = 0,
    H5S_SEL_POINTS     = 1,
    H5S_SEL_HYPERSLABS = 2,
    H5S_SEL_ALL        = 3,
    H5S_SEL_N
} H5S_sel_type;
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL herr_t H5Sclose(hid_t space_id);
H5_DLL hid_t H5Scombine_hyperslab(hid_t space_id, H5S_seloper_t op, const hsize_t start[],
                                  const hsize_t stride[], const hsize_t count[], const hsize_t block[]);
H5_DLL hid_t H5Scombine_select(hid_t space1_id, H5S_seloper_t op, hid_t space2_id);
H5_DLL hid_t H5Scopy(hid_t space_id);
H5_DLL hid_t H5Screate(H5S_class_t type);
H5_DLL hid_t H5Screate_simple(int rank, const hsize_t dims[], const hsize_t maxdims[]);
H5_DLL hid_t H5Sdecode(const void *buf);
H5_DLL herr_t H5Sencode2(hid_t obj_id, void *buf, size_t *nalloc, hid_t fapl);
H5_DLL herr_t H5Sextent_copy(hid_t dst_id, hid_t src_id);
H5_DLL htri_t H5Sextent_equal(hid_t space1_id, hid_t space2_id);
H5_DLL htri_t H5Sget_regular_hyperslab(hid_t spaceid, hsize_t start[], hsize_t stride[], hsize_t count[],
                                       hsize_t block[]);
H5_DLL herr_t H5Sget_select_bounds(hid_t spaceid, hsize_t start[], hsize_t end[]);
H5_DLL hssize_t H5Sget_select_elem_npoints(hid_t spaceid);
H5_DLL herr_t H5Sget_select_elem_pointlist(hid_t spaceid, hsize_t startpoint, hsize_t numpoints,
                                           hsize_t buf[]);
H5_DLL herr_t H5Sget_select_hyper_blocklist(hid_t spaceid, hsize_t startblock, hsize_t numblocks,
                                            hsize_t buf[]);
H5_DLL hssize_t H5Sget_select_hyper_nblocks(hid_t spaceid);
H5_DLL hssize_t H5Sget_select_npoints(hid_t spaceid);
H5_DLL H5S_sel_type H5Sget_select_type(hid_t spaceid);
H5_DLL int H5Sget_simple_extent_dims(hid_t space_id, hsize_t dims[], hsize_t maxdims[]);
H5_DLL int H5Sget_simple_extent_ndims(hid_t space_id);
H5_DLL hssize_t H5Sget_simple_extent_npoints(hid_t space_id);
H5_DLL H5S_class_t H5Sget_simple_extent_type(hid_t space_id);
H5_DLL htri_t H5Sis_regular_hyperslab(hid_t spaceid);
H5_DLL htri_t H5Sis_simple(hid_t space_id);
H5_DLL herr_t H5Smodify_select(hid_t space1_id, H5S_seloper_t op, hid_t space2_id);
H5_DLL herr_t H5Soffset_simple(hid_t space_id, const hssize_t *offset);
H5_DLL herr_t H5Ssel_iter_close(hid_t sel_iter_id);
H5_DLL hid_t H5Ssel_iter_create(hid_t spaceid, size_t elmt_size, unsigned flags);
H5_DLL herr_t H5Ssel_iter_get_seq_list(hid_t sel_iter_id, size_t maxseq, size_t maxelmts, size_t *nseq,
                                       size_t *nelmts, hsize_t *off, size_t *len);
H5_DLL herr_t H5Ssel_iter_reset(hid_t sel_iter_id, hid_t space_id);
H5_DLL herr_t H5Sselect_adjust(hid_t spaceid, const hssize_t *offset);
H5_DLL herr_t H5Sselect_all(hid_t spaceid);
H5_DLL herr_t H5Sselect_copy(hid_t dst_id, hid_t src_id);
H5_DLL herr_t H5Sselect_elements(hid_t space_id, H5S_seloper_t op, size_t num_elem, const hsize_t *coord);
H5_DLL herr_t H5Sselect_hyperslab(hid_t space_id, H5S_seloper_t op, const hsize_t start[],
                                  const hsize_t stride[], const hsize_t count[], const hsize_t block[]);
H5_DLL htri_t H5Sselect_intersect_block(hid_t space_id, const hsize_t *start, const hsize_t *end);
H5_DLL herr_t H5Sselect_none(hid_t spaceid);
H5_DLL hid_t H5Sselect_project_intersection(hid_t src_space_id, hid_t dst_space_id,
                                            hid_t src_intersect_space_id);
H5_DLL htri_t H5Sselect_shape_same(hid_t space1_id, hid_t space2_id);
H5_DLL htri_t H5Sselect_valid(hid_t spaceid);
H5_DLL herr_t H5Sset_extent_none(hid_t space_id);
H5_DLL herr_t H5Sset_extent_simple(hid_t space_id, int rank, const hsize_t dims[], const hsize_t max[]);
#ifndef H5_NO_DEPRECATED_SYMBOLS
H5_DLL herr_t H5Sencode1(hid_t obj_id, void *buf, size_t *nalloc);
#endif
#ifdef __cplusplus
}
#endif
#endif
