% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdf5-functions.R
\name{h5Class}
\alias{h5Class}
\alias{is.H5D}
\alias{is.H5Group}
\title{Get the class of an HDF5 link}
\usage{
h5Class(file, name)

is.H5D(file, name)

is.H5Group(file, name)
}
\arguments{
\item{file}{An existing HDF5 file}

\item{name}{Name of a link in \code{file}}
}
\value{
\code{h5Class} returns a character specifying the class of the query HDF5 
link (typically H5D, H5Group or H5File).

\code{is.H5D} and \code{is.H5Group} return a logical value.
}
\description{
Functions to get or check the class of an HDF5 link.
}
\examples{
file <- system.file("extdata", "pbmc_small.h5ad", package = "hdf5r.Extra")
h5Class(file, "X")
h5Class(file, "obs")
is.H5D(file, "X")
is.H5Group(file, "obs")

}
