% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes_H5T.R
\docType{class}
\name{H5T_FLOAT-class}
\alias{H5T_FLOAT-class}
\alias{H5T_FLOAT}
\title{Class for HDF5 floating point datatypes.}
\value{
Object of class \code{\link[=H5T_FLOAT]{H5T_FLOAT}}.
}
\description{
Inherits from class \code{\link[=H5T]{H5T}}. Users should not create float types with this class, but instead
use e.g. \code{h5types$H5T_NATIVE_DOUBLE}. Using the functions of this class, many aspects of the representation of the
floating point number can then be manipulated.
}
\section{Methods}{

\describe{
\item{\code{set_fields(spos, epos, esize, mpos, msize)}}{

This function implements the HDF5-API function H5Tset_fields.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/v1_10/group___h5_t.html} for details.}

\item{\code{get_fields()}}{

This function implements the HDF5-API function H5Tget_fields.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/v1_10/group___h5_t.html} for details.}

\item{\code{set_ebias(ebias)}}{

This function implements the HDF5-API function H5Tset_ebias.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/v1_10/group___h5_t.html} for details.}

\item{\code{get_ebias()}}{

This function implements the HDF5-API function H5Tget_ebias.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/v1_10/group___h5_t.html} for details.}

\item{\code{set_norm(norm)}}{

This function implements the HDF5-API function H5Tset_norm.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/v1_10/group___h5_t.html} for details.}

\item{\code{get_norm()}}{

This function implements the HDF5-API function H5Tget_norm.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/v1_10/group___h5_t.html} for details.}

\item{\code{set_inpad(inpad)}}{

This function implements the HDF5-API function H5Tset_inpad.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/v1_10/group___h5_t.html} for details.}

\item{\code{get_inpad()}}{

This function implements the HDF5-API function H5Tget_inpad.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/v1_10/group___h5_t.html} for details.}

\item{\code{describe()}}{

Print a detailed description of the datatype; this is experimental}
}}

\seealso{
\code{\link[=H5T]{H5T}}
}
\author{
Holger Hoefling
}
