% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string-manipulation.R
\name{add_article}
\alias{add_article}
\title{Append a/an to word}
\usage{
add_article(x)
}
\arguments{
\item{x}{string or numeric value}
}
\value{
Returns a vector the same length as the input.
}
\description{
Append a/an to word
}
\details{
This function uses crude logic to append 'a' or 'an' to numbers and phrases.
\itemize{
\item words that start with aeiou
\item negative numbers always start with 'a', ex: 'a -3' or 'a -8'
\item decimals always start with 'a' ex: 0.4 is usually pronounced
'a zero point four' or 'a point four'
\item numbers starting with 8 are always 'an'
\item if the integer that comes after thousand or million is 11 or 18 then 'an'
\itemize{
\item 18,000 becomes 18 and that becomes 'an 18'
}
\item if the integer that comes after thousand or million is in
1, 10, 12, 13, 14, 15, 16, 17, 19 then 'a'
\itemize{
\item 15,500 becomes 15 and that becomes 'a 15'
}
\item otherwise 'a'
}
}
\examples{
add_article("increase")

add_article("decrease")

add_article(c(1, 8, 10, 11, 18, 20, 80))

add_article(18123)

stats::setNames(
  add_article(1.8 * 10^(1:7)),
  prettyNum(1.8 * 10^(1:7), big.mark = ",")
)

}
