% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{generateAUC}
\alias{generateAUC}
\title{Generate ROC or PR curve for a dataset.}
\usage{
generateAUC(predictions, labels, aucType = "SS", plotFlg = FALSE,
  allCutoffsFlg = FALSE)
}
\arguments{
\item{predictions}{A vector of predictions from a machine learning model.}

\item{labels}{A vector of the true labels. Must be the same length as 
predictions.}

\item{aucType}{A string. Indicates AUC_ROC or AU_PR and can be "SS" or "PR". 
Defaults to SS.}

\item{plotFlg}{Binary value controlling plots. Defaults to FALSE (no).}

\item{allCutoffsFlg}{Binary value controlling list of all thresholds. 
Defaults to FALSE (no).}
}
\value{
AUC: A number between 0 and 1. Integral AUC of chosen plot type.

IdealCutoffs: Array of cutoff and associated TPR/FPR or pre/rec.

Performance: ROCR performance class containing all ROC information.
}
\description{
Generates ROC curve and AUC for Sensitivity/Specificity or 
Precision/Recall.
}
\examples{

# generate data
# example probablities
df <- data.frame(a = rep( seq(0,1,by=0.1), times=9))
# example ground truth values
df[,'b'] <- (runif(99,0,1)*df[,'a']) > 0.5

# prepare vectors
pred <- df[,'a']
labels <- df[,'b']

# generate the AUC
auc = generateAUC(predictions = pred, 
                  labels = labels,
                  aucType = 'SS',
                  plotFlg = TRUE,
                  allCutoffsFlg = TRUE)

}
\references{
\url{http://healthcare.ai}
}
\seealso{
\code{\link{healthcareai}}
}
