% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/healthcareai.R
\docType{package}
\name{healthcareai}
\alias{healthcareai}
\alias{healthcareai-package}
\title{healthcareai: a streamlined way to develop and deploy models}
\description{
healthcareai provides a clean interface that lets one create and compare multiple
models on your data, and then deploy the model that is most accurate. healthcareai
also includes functions for data exploration, data cleaning, and model evaluation.
}
\details{
This is done in a four-step process:

\enumerate{
\item{\strong{Load and profile data}}{\cr Use \code{\link{selectData}} to pull data directly 
from the SQL database. Then, \code{\link{featureAvailabilityProfiler}} and 
\code{\link{countPercentEmpty}} can help determine how many null values are in a 
column and how they are populated over time. \code{\link{calculateTargetedCorrelations}} 
and \code{\link{findTrends}} can help explore data. Manipulate dates using 
\code{\link{orderByDate}} and \code{\link{countDaysSinceFirstDate}}. }

\item{\strong{Develop a machine learning model}}{\cr Use \code{\link{LassoDevelopment}} or
\code{\link{RandomForestDevelopment}} and test different combinations of 
features. Determine the best model using: 
\itemize{
\item Area under the ROC curve or area under the Performance-Recall 
curve for classification problems (yes or no response). 
\item Mean squared error for regression problems (continuous response).
}}

\item{\strong{Deploy the machine learning model}}{\cr
\code{\link{LassoDeployment}} or \code{\link{RandomForestDeployment}} to
create a final model, automatically save it, predict against test data, and
push predicted values into a SQL environment. This can be tested locally,
but eventually lives on the production server.}

\item{\strong{Monitor performance in production environment}}{\cr After 
generating predictions and getting ground truth values, use 
\code{\link{generateAUC}} to monitor performance over time. This 
should happen after greater than 1000 predictions have been made or 30 days
have passed.}
}
}
\references{
\url{http://healthcare.ai}
}
\seealso{
\code{\link{LinearMixedModelDevelopment}}

\code{\link{LinearMixedModelDeployment}}

\code{\link{RiskAdjustedComparisons}}

\code{\link{imputeColumn}}

\code{\link{groupedLOCF}}

\code{\link{selectData}}

\code{\link{writeData}}

\code{\link{orderByDate}}

\code{\link{isBinary}}

\code{\link{removeRowsWithNAInSpecCol}}

\code{\link{removeColsWithAllSameValue}}

\code{\link{returnColsWithMoreThanFiftyCategories}}

\code{\link{findTrends}}

\code{\link{convertDateTimeColToDummies}}

\code{\link{countDaysSinceFirstDate}}

\code{\link{calculateTargetedCorrelations}}

\code{\link{calculateAllCorrelations}}

\code{\link{featureAvailabilityProfiler}}

\code{\link{generateAUC}}
}
