% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common-correlations.R
\name{calculateTargetedCorrelations}
\alias{calculateTargetedCorrelations}
\title{Correlation analysis on an input table, focusing on one target variable}
\usage{
calculateTargetedCorrelations(df, targetCol)
}
\arguments{
\item{df}{A data frame}

\item{targetCol}{Name of target column against which correlations will be
calculated}
}
\value{
A data frame with column names and corresponding correlations and
p-values with the target column
}
\description{
Calculates correlations between each numeric column in a table
and and a target column
}
\examples{
df <- data.frame(a=c(1,2,3,4,5,6),
b=c(6,5,4,3,2,1),
c=c(3,4,2,1,3,5),
d=c('M','F','F','F','M','F')) #<- is ignored

dfResult <- calculateTargetedCorrelations(df=df,targetCol='c')
dfResult
}
\references{
\url{http://healthcareai-r.readthedocs.io}
}
\seealso{
\code{\link{healthcareai}}
}
