% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{impute}
\alias{impute}
\title{Impute data and return a reusable recipe}
\usage{
impute(d = NULL, ..., recipe = NULL, numeric_method = "mean",
  nominal_method = "new_category", numeric_params = NULL,
  nominal_params = NULL, verbose = FALSE)
}
\arguments{
\item{d}{A dataframe or tibble containing data to impute.}

\item{...}{Optional. Unquoted variable names to not be imputed. These will be
returned unaltered.}

\item{recipe}{Optional, a recipe object or an imputed data frame (containing
a recipe object as an attribute). If provided, this recipe will be applied
to impute new data contained in d with values saved in the recipe. Use this
param if you'd like to apply the same values used for imputation on a
training dataset in production.}

\item{numeric_method}{Defaults to \code{"mean"}. Other choices are
\code{"bagimpute"} or \code{"knnimpute"}.}

\item{nominal_method}{Defaults to \code{"new_category"}. Other choices are
\code{"bagimpute"} or \code{"knnimpute"}.}

\item{numeric_params}{A named list with parmeters to use with chosen
 imputation method on numeric data. Options are
\code{bag_model} (bagimpute only), \code{bag_trees} (bagimpute
only), \code{bag_options} (bagimpute only), \code{bag_trees}
(bagimpute only), \code{knn_K} (knnimpute only), \code{impute_with}
(knnimpute only), (bag or knn) or \code{seed_val} (bag or knn).
See \link{step_bagimpute} or \link{step_knnimpute} for details.}

\item{nominal_params}{A named list with parmeters to use with chosen
 imputation method on nominal data. Options are
\code{bag_model} (bagimpute only), \code{bag_trees} (bagimpute
only), \code{bag_options} (bagimpute only), \code{bag_trees}
(bagimpute only), \code{knn_K} (knnimpute only), \code{impute_with}
(knnimpute only), (bag or knn) or \code{seed_val} (bag or knn).
See \link{step_bagimpute} or \link{step_knnimpute} for details.}

\item{verbose}{Gives a print out of what will be imputed and which method
will be used.}
}
\value{
Imputed data frame with reusable recipe object for future imputation
  in attribute "recipe".
}
\description{
\code{impute} will impute your data using a variety of methods
for both nominal and numeric data. Currently supports mean (numeric only),
new_category (categorical only), bagged trees, or knn.
}
\examples{
d <- pima_diabetes
d_train <- d[1:700, ]
d_test <- d[701:768, ]
# Train imputer
train_imputed <- impute(d = d_train, patient_id, diabetes)
# Apply to new data
impute(d = d_test, patient_id, diabetes, recipe = train_imputed)
# Specify methods:
impute(d = d_train, patient_id, diabetes, numeric_method = "bagimpute",
nominal_method = "new_category")
# Specify method and param:
impute(d = d_train, patient_id, diabetes, nominal_method = "knnimpute",
nominal_params = list(knn_K = 4))
}
