% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_add_levels.R
\name{step_add_levels}
\alias{step_add_levels}
\alias{tidy.step_add_levels}
\title{Add levels to nominal variables}
\usage{
step_add_levels(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  cols = NULL,
  levels = c("other", "missing"),
  skip = FALSE,
  id = rand_id("bagimpute")
)

\method{tidy}{step_add_levels}(x, ...)
}
\arguments{
\item{recipe}{recipe object. This step will be added}

\item{...}{One or more selector functions}

\item{role}{Ought to be nominal}

\item{trained}{Has the recipe been prepped?}

\item{cols}{columns to be prepped}

\item{levels}{Factor levels to add to variables. Default = c("other",
"missing")}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked?}

\item{id}{a unique step id that will be used to unprep}

\item{x}{A `step_add_levels` object.}
}
\value{
Recipe with the new step
}
\description{
Add levels to nominal variables
}
\examples{
library(recipes)
d <- data.frame(num = 1:30,
                has_missing = c(rep(NA, 10), rep('b', 20)),
                has_rare = c("rare", rep("common", 29)),
                has_both = c("rare", NA, rep("common", 28)),
                has_neither = c(rep("cat1", 15), rep("cat2", 15)))
rec <- recipe( ~ ., d) \%>\%
  step_add_levels(all_nominal()) \%>\%
  prep(training = d)
baked <- bake(rec, d)
lapply(d[, sapply(d, is.factor)], levels)
lapply(baked[, sapply(baked, is.factor)], levels)
}
