% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{OrderedSampleMultipleind}
\alias{OrderedSampleMultipleind}
\title{World Health Organization (WHO)}
\format{
\subsection{\code{OrderedSampleMultipleind}}{

A data frame with 10 rows and 11 columns:
\describe{
\item{indicator}{indicator name}
\item{dimension}{dimension of inequality}
\item{subgroup}{population subgroup within a given dimension of inequality}
\item{subgroup_order}{the order of subgroups in an increasing sequence}
\item{estimate}{subgroup estimate}
\item{se}{standard error of the subgroup estimate}
\item{population}{number of people within each subgroup}
\item{setting_average}{indicator average for the setting}
\item{favourable_indicator}{favourable (1) or non-favourable (0) indicator}
\item{ordered_dimension}{ordered (1) or non-ordered (0) dimension}
\item{indicator_scale}{scale of the indicator}
}
}
}
\source{
WHO Health Inequality Data Repository\url{https://www.who.int/data/inequality-monitor/data}
}
\usage{
OrderedSampleMultipleind
}
\description{
This dataset contains sample data for computing ordered summary measures of
health inequality. It contains data from a household survey for two
indicators, the proportion of births attended by skilled health personnel
and under-five mortality rate, disaggregated by economic status.
}
\details{
The proportion of births attended by skilled health personnel is calculated
as the number of births attended by skilled health personnel divided by the
total number of live births to women aged 15-49 years occurring in the
period prior to the survey.

Skilled health personnel include doctors, nurses, midwives and other
medically trained personnel, as defined according to each country. This is
in line with the definition used by the Countdown to 2030 Collaboration,
Demographic and Health Surveys (DHS), Multiple Indicator Cluster Surveys
(MICS) and Reproductive Health Surveys (RHS).

The under-five mortality rate is the probability (expressed as a rate per
1000 live births) of a child born in a specific year or period dying before
reaching the age of five years. It is calculated as the number of deaths at
age 0-5 years divided by the number of surviving children at the beginning
of the specified age range during the 10 years prior to the survey.

Economic status is determined using a wealth index, which is based on owning
selected assets and having access to certain services. The wealth index is
divided into five equal subgroups (quintiles) that each account for 20\% of
the population. Economic status is an ordered dimension (meaning that the
subgroups have an inherent ordering).

This dataset can be used to calculate ordered summary measures of health
inequality, including: absolute concentration index (ACI), relative
concentration index (RCI), slope index of inequality (SII) and relative
index of inequality (RII). It can also be used to calculate the impact
measures population attributable risk (PAR) and population attributable
fraction (PAF).
}
\examples{
head(OrderedSampleMultipleind)
summary(OrderedSampleMultipleind)
}
\keyword{datasets}
