% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrape_data.R
\name{scrape_one_post}
\alias{scrape_one_post}
\title{Scrape one initial post}
\usage{
scrape_one_post(url, From = 1L, To = Inf, get_user_info = TRUE)
}
\arguments{
\item{url}{URL to the post to scrape}

\item{From}{The starting page number. Default is the first page}

\item{To}{The ending page number. Default (Inf) is the last page (so all pages)}

\item{get_user_info}{Get users' profile information. It includes the date of joining the forum and the total posts they have sent. The default is TRUE.}
}
\value{
A data frame
}
\description{
Get the data from one initial post by entering its url
}
\examples{
\donttest{
## get two pages of data from the post titled "Can Gastritis be cured?"
post_url = "https://patient.info/forums/discuss/can-gastritis-be-cured--613999"
scrape_one_post(url = post_url, From = 1, To = 2)
}

}
