% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl-hai-distribution-comparison.R
\name{hai_distribution_comparison_tbl}
\alias{hai_distribution_comparison_tbl}
\title{Compare Data Against Distributions}
\usage{
hai_distribution_comparison_tbl(
  .x,
  .distributions = c("gamma", "beta"),
  .normalize = TRUE
)
}
\arguments{
\item{.x}{The numeric vector to analyze.}

\item{.distributions}{A character vector of distributions to check. For example,
c("gamma","beta")}

\item{.normalize}{A boolean value of TRUE/FALSE, the default is TRUE. This
will normalize the data using the \code{hai_scale_zero_one_vec} function.}
}
\value{
A tibble.
}
\description{
This function will attempt to get some key information on the
data you pass to it. It will also automatically normalize the data from 0 to 1.
This will not change the distribution just it's scale in order to make sure
that many different types of distributions can be fit to the data, which
should help identify what the distribution of the passed data could be.

The resulting output has attributes added to it that get used in other functions
that are meant to compliment each other.

This function will automatically pass the \code{.x} parameter to \code{\link[=hai_skewness_vec]{hai_skewness_vec()}}
and \code{\link[=hai_kurtosis_vec]{hai_kurtosis_vec()}} in order to help create the random data
from the distributions.

The distributions that can be chosen from are:\tabular{ll}{
   Distribution \tab R stats::dist \cr
   normal \tab rnorm \cr
   uniform \tab runif \cr
   exponential \tab rexp \cr
   logistic \tab rlogis \cr
   beta \tab rbeta \cr
   lognormal \tab rlnorm \cr
   gamma \tab rgamma \cr
   weibull \tab weibull \cr
   chisquare \tab rchisq \cr
   cauchy \tab rcauchy \cr
   hypergeometric \tab rhyper \cr
   f \tab rf \cr
   poisson \tab rpois \cr
}
}
\details{
Get information on the empirical distribution of your data along with
generated densities of other distributions. This information is in the resulting
tibble that is generated. Three columns will generate, Distribution, from the
\verb{param .distributions}, \code{dist_data} which is a list vector of density
values passed to the underlying stats r distribution function, and \code{density_data},
which is the \code{dist_data} column passed to \code{list(stats::density(unlist(dist_data)))}

This has the effect of giving you the desired vector that can be used in resultant
plots (\code{dist_data}) or you can interact with the \code{density} object itself.

If the skewness of the distribution is negative, then for the gamma and beta
distributions the skew is set equal to the kurtosis and the kurtosis is set
equal to \code{sqrt((skew)^2)}
}
\examples{
x_vec <- hai_scale_zero_one_vec(mtcars$mpg)
df <- hai_distribution_comparison_tbl(
  .x = x_vec,
  .distributions = c("beta", "gamma")
)
df

}
\seealso{
Other Distribution Functions: 
\code{\link{hai_get_density_data_tbl}()},
\code{\link{hai_get_dist_data_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Distribution Functions}
