% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-hai-histogram-facet.R
\name{hai_histogram_facet_plot}
\alias{hai_histogram_facet_plot}
\title{Histogram Facet Plot}
\usage{
hai_histogram_facet_plot(
  .data,
  .bins = 10,
  .scale_data = FALSE,
  .ncol = 5,
  .fct_reorder = FALSE,
  .fct_rev = FALSE,
  .fill = "steelblue",
  .color = "white",
  .scale = "free",
  .interactive = FALSE
)
}
\arguments{
\item{.data}{The data you want to pass to the function.}

\item{.bins}{The number of bins for the histograms.}

\item{.scale_data}{This is a boolean set to FALSE. TRUE will use \code{hai_scale_zero_one_vec()}
to \verb{[0, 1]} scale the data.}

\item{.ncol}{The number of columns for the facet_warp argument.}

\item{.fct_reorder}{Should the factor column be reordered? TRUE/FALSE, default of FALSE}

\item{.fct_rev}{Should the factor column be reversed? TRUE/FALSE, default of FALSE}

\item{.fill}{Default is \code{steelblue}}

\item{.color}{Default is 'white'}

\item{.scale}{Default is 'free'}

\item{.interactive}{Default is FALSE, TRUE will produce a \code{plotly} plot.}
}
\value{
A ggplot or plotly plot
}
\description{
This function expects a data.frame/tibble and will return a
faceted histogram.
}
\details{
Takes in a data.frame/tibble and returns a faceted historgram.
}
\examples{

hai_histogram_facet_plot(.data = iris)
hai_histogram_facet_plot(.data = iris, .scale_data = TRUE)

}
\author{
Steven P. Sanderson II, MPH
}
