% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_tbl_functions.R
\name{los_ra_index_summary_tbl}
\alias{los_ra_index_summary_tbl}
\title{Make LOS and Readmit Index Summary Tibble}
\usage{
los_ra_index_summary_tbl(
  .data,
  .max_los = 15,
  .alos_col,
  .elos_col,
  .readmit_rate,
  .readmit_bench
)
}
\arguments{
\item{.data}{The data you are going to analyze.}

\item{.max_los}{You can give a maximum LOS value. Lets say you typically do
not see los over 15 days, you would then set .max_los to 15 and all values greater
than .max_los will be grouped to .max_los}

\item{.alos_col}{The Average Length of Stay column}

\item{.elos_col}{The Expected Length of Stay column}

\item{.readmit_rate}{The Actual Readmit Rate column}

\item{.readmit_bench}{The Expected Readmit Rate column}
}
\value{
A tibble
}
\description{
Create the length of stay and readmit index summary tibble
}
\details{
\itemize{
\item Expects a tibble
\item Expects the following columns and there should only be these 4
}
\enumerate{
\item Length Of Stay Actual - Should be an integer
\item Length Of Stacy Benchmark - Should be an integer
\item Readmit Rate Actual - Should be 0/1 for each record, 1 = readmitted, 0 did not.
\item Readmit Rate Benchmark - Should be a percentage from the benchmark file.
}
\itemize{
\item This will add a column called visits that will be the count of records per
length of stay from 1 to .max_los
\item The .max_los param can be left blank and the function will default to 15. If
this is not a good default and you don't know what it should be then set it to
75 percentile from the \link[stats:quantile]{stats::quantile} function using the defaults, like so
.max_los = \code{stats::quantile(data_tbl$alos)[[4]]}
\item Uses all data to compute variance, if you want it for a particular time frame
you will have to filter the data that goes into the .data argument. It is
suggested to use \code{timetk::filter_by_time()}
\item The index is computed as the excess of the length of stay or readmit rates
over their respective expectations.
}
}
\examples{

suppressPackageStartupMessages(library(dplyr))

data_tbl <- tibble(
  "alos"            = runif(186, 1, 20)
  , "elos"          = runif(186, 1, 17)
  , "readmit_rate"  = runif(186, 0, .25)
  , "readmit_bench" = runif(186, 0, .2)
)

los_ra_index_summary_tbl(
  .data = data_tbl
  , .max_los       = 15
  , .alos_col      = alos
  , .elos_col      = elos
  , .readmit_rate  = readmit_rate
  , .readmit_bench = readmit_bench
  )

los_ra_index_summary_tbl(
  .data = data_tbl
  , .max_los       = 10
  , .alos_col      = alos
  , .elos_col      = elos
  , .readmit_rate  = readmit_rate
  , .readmit_bench = readmit_bench
  )

}
\author{
Steven P. Sanderson II, MPH
}
