% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_signature_tbl.R
\name{ts_signature_tbl}
\alias{ts_signature_tbl}
\title{Make a Time Enhanced Tibble}
\usage{
ts_signature_tbl(.data, .date_col, .pad_time = TRUE, ...)
}
\arguments{
\item{.data}{The data that is being analyzed.}

\item{.date_col}{The column that holds the date.}

\item{.pad_time}{Boolean TRUE/FALSE. If TRUE then the \code{\link[timetk:pad_by_time]{timetk::pad_by_time()}}
function is called and used on the data.frame before the modification. The
default is TRUE.}

\item{...}{Grouping variables to be used by \code{\link[dplyr:group_by]{dplyr::group_by()}} before using
\code{\link[timetk:pad_by_time]{timetk::pad_by_time()}}}
}
\value{
A tibble
}
\description{
Returns a tibble that adds the time series signature from the
\code{\link[timetk:tk_augment_timeseries]{timetk::tk_augment_timeseries_signature()}} function. All added from a chosen
date column defined by the \code{.date_col} parameter.
}
\details{
\itemize{
\item Supply data with a date column and this will add the year, month, week, week day and hour
to the tibble. The original date column is kept.
\item Returns a time-series signature tibble.
\item You must know the data going into the function and if certain columns
should be dropped or kept when using further functions
}
}
\examples{
library(timetk)

ts_signature_tbl(
  .data       = m4_daily
  , .date_col = date
  , .pad_time = TRUE
  , id
)

}
