% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_yaml_header.R
\name{create_yaml_header}
\alias{create_yaml_header}
\title{Convert list objects into R Markdown YAML headers}
\usage{
create_yaml_header(
  ...,
  line.sep = c("\\n", "\\r\\n", "\\r"),
  indent = 2,
  unicode = TRUE,
  indent.mapping.sequence = FALSE,
  handlers = NULL
)
}
\arguments{
\item{...}{A set of objects that will be combined into the YAML header.
Objects may be provided as lists (the structure
list("outputs" = "html_document") translates to outputs: html_document)
or as single-item named vectors (passing "title" = "My Report" to ... will
translate to title: "My Report").}

\item{line.sep, indent, unicode, indent.mapping.sequence, handlers}{Additional arguments to be passed to \code{\link[yaml]{as.yaml}}}
}
\value{
Returns a string formatted for use as an R Markdown YAML header.
}
\description{
This function tweaks the behavior of \code{\link[yaml]{as.yaml}} to return
a string which can immediately be used as an R Markdown YAML header.
It's designed to accept both deeply nested lists and simpler list formats
to make reasoning about your header easier.
}
\examples{
headerContent <- list(
  "title" = "Testing YAML",
  "author" = "Mike Mahoney",
  "output" = list(
    "flexdashboard::flex_dashboard" = list(
      "vertical_layout" = "fill",
      "orientation" = "rows",
      "css" = "bootstrap.css"
    )
  )
)
create_yaml_header(headerContent)
create_yaml_header(
  "title" = "testing",
  "params" = list("data" = "NA"),
  list("author" = "Mike Mahoney")
)
}
\seealso{
Other manipulation functions: 
\code{\link{heddle}()},
\code{\link{make_template}()},
\code{\link{use_parameters}()}
}
\concept{manipulation functions}
